/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResources;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperationsBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperationsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MatchResourcesFluentImpl<A extends MatchResourcesFluent<A>>
extends BaseFluent<A>
implements MatchResourcesFluent<A> {
    private ArrayList<NamedRuleWithOperationsBuilder> excludeResourceRules = new ArrayList();
    private String matchPolicy;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder objectSelector;
    private ArrayList<NamedRuleWithOperationsBuilder> resourceRules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MatchResourcesFluentImpl() {
    }

    public MatchResourcesFluentImpl(MatchResources instance) {
        this.withExcludeResourceRules(instance.getExcludeResourceRules());
        this.withMatchPolicy(instance.getMatchPolicy());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withObjectSelector(instance.getObjectSelector());
        this.withResourceRules(instance.getResourceRules());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToExcludeResourceRules(Integer index, NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        this._visitables.get("excludeResourceRules").add(index >= 0 ? index.intValue() : this._visitables.get("excludeResourceRules").size(), builder);
        this.excludeResourceRules.add(index >= 0 ? index.intValue() : this.excludeResourceRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExcludeResourceRules(Integer index, NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this._visitables.get("excludeResourceRules").size()) {
            this._visitables.get("excludeResourceRules").add(builder);
        } else {
            this._visitables.get("excludeResourceRules").set(index, builder);
        }
        if (index < 0 || index >= this.excludeResourceRules.size()) {
            this.excludeResourceRules.add(builder);
        } else {
            this.excludeResourceRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExcludeResourceRules(NamedRuleWithOperations ... items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExcludeResourceRules(NamedRuleWithOperations ... items) {
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").remove(builder);
            if (this.excludeResourceRules == null) continue;
            this.excludeResourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("excludeResourceRules").remove(builder);
            if (this.excludeResourceRules == null) continue;
            this.excludeResourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExcludeResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        if (this.excludeResourceRules == null) {
            return (A)this;
        }
        Iterator<NamedRuleWithOperationsBuilder> each = this.excludeResourceRules.iterator();
        Object visitables = this._visitables.get("excludeResourceRules");
        while (each.hasNext()) {
            NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedRuleWithOperations> getExcludeResourceRules() {
        return this.excludeResourceRules != null ? MatchResourcesFluentImpl.build(this.excludeResourceRules) : null;
    }

    @Override
    public List<NamedRuleWithOperations> buildExcludeResourceRules() {
        return this.excludeResourceRules != null ? MatchResourcesFluentImpl.build(this.excludeResourceRules) : null;
    }

    @Override
    public NamedRuleWithOperations buildExcludeResourceRule(Integer index) {
        return this.excludeResourceRules.get(index).build();
    }

    @Override
    public NamedRuleWithOperations buildFirstExcludeResourceRule() {
        return this.excludeResourceRules.get(0).build();
    }

    @Override
    public NamedRuleWithOperations buildLastExcludeResourceRule() {
        return this.excludeResourceRules.get(this.excludeResourceRules.size() - 1).build();
    }

    @Override
    public NamedRuleWithOperations buildMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExcludeResourceRules(List<NamedRuleWithOperations> excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this._visitables.get("excludeResourceRules").removeAll(this.excludeResourceRules);
        }
        if (excludeResourceRules != null) {
            this.excludeResourceRules = new ArrayList();
            for (NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        } else {
            this.excludeResourceRules = null;
        }
        return (A)this;
    }

    @Override
    public A withExcludeResourceRules(NamedRuleWithOperations ... excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this.excludeResourceRules.clear();
        }
        if (excludeResourceRules != null) {
            for (NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExcludeResourceRules() {
        return this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty();
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> addNewExcludeResourceRule() {
        return new ExcludeResourceRulesNestedImpl();
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> addNewExcludeResourceRuleLike(NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNestedImpl(-1, item);
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> setNewExcludeResourceRuleLike(Integer index, NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNestedImpl(index, item);
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> editExcludeResourceRule(Integer index) {
        if (this.excludeResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit excludeResourceRules. Index exceeds size.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> editFirstExcludeResourceRule() {
        if (this.excludeResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(0, this.buildExcludeResourceRule(0));
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> editLastExcludeResourceRule() {
        int index = this.excludeResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    @Override
    public MatchResourcesFluent.ExcludeResourceRulesNested<A> editMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.excludeResourceRules.size(); ++i) {
            if (!predicate.test(this.excludeResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching excludeResourceRules. No match found.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    @Override
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    @Override
    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public MatchResourcesFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public MatchResourcesFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public MatchResourcesFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public MatchResourcesFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public MatchResourcesFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public A withObjectSelector(LabelSelector objectSelector) {
        this._visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector != null) {
            this.objectSelector = new LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        } else {
            this.objectSelector = null;
            this._visitables.get("objectSelector").remove(this.objectSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    @Override
    public MatchResourcesFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    @Override
    public MatchResourcesFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    @Override
    public MatchResourcesFluent.ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector());
    }

    @Override
    public MatchResourcesFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public MatchResourcesFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : item);
    }

    @Override
    public A addToResourceRules(Integer index, NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        this._visitables.get("resourceRules").add(index >= 0 ? index.intValue() : this._visitables.get("resourceRules").size(), builder);
        this.resourceRules.add(index >= 0 ? index.intValue() : this.resourceRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResourceRules(Integer index, NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this._visitables.get("resourceRules").size()) {
            this._visitables.get("resourceRules").add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
        }
        if (index < 0 || index >= this.resourceRules.size()) {
            this.resourceRules.add(builder);
        } else {
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResourceRules(NamedRuleWithOperations ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceRules(NamedRuleWithOperations ... items) {
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            if (this.resourceRules == null) continue;
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceRules(Collection<NamedRuleWithOperations> items) {
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            if (this.resourceRules == null) continue;
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<NamedRuleWithOperationsBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedRuleWithOperations> getResourceRules() {
        return this.resourceRules != null ? MatchResourcesFluentImpl.build(this.resourceRules) : null;
    }

    @Override
    public List<NamedRuleWithOperations> buildResourceRules() {
        return this.resourceRules != null ? MatchResourcesFluentImpl.build(this.resourceRules) : null;
    }

    @Override
    public NamedRuleWithOperations buildResourceRule(Integer index) {
        return this.resourceRules.get(index).build();
    }

    @Override
    public NamedRuleWithOperations buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    @Override
    public NamedRuleWithOperations buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    @Override
    public NamedRuleWithOperations buildMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceRules(List<NamedRuleWithOperations> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").removeAll(this.resourceRules);
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceRules(NamedRuleWithOperations ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
        }
        if (resourceRules != null) {
            for (NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNestedImpl();
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> addNewResourceRuleLike(NamedRuleWithOperations item) {
        return new ResourceRulesNestedImpl(-1, item);
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> setNewResourceRuleLike(Integer index, NamedRuleWithOperations item) {
        return new ResourceRulesNestedImpl(index, item);
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> editResourceRule(Integer index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public MatchResourcesFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchResourcesFluentImpl that = (MatchResourcesFluentImpl)o;
        if (this.excludeResourceRules != null ? !this.excludeResourceRules.equals(that.excludeResourceRules) : that.excludeResourceRules != null) {
            return false;
        }
        if (this.matchPolicy != null ? !this.matchPolicy.equals(that.matchPolicy) : that.matchPolicy != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.objectSelector != null ? !this.objectSelector.equals(that.objectSelector) : that.objectSelector != null) {
            return false;
        }
        if (this.resourceRules != null ? !this.resourceRules.equals(that.resourceRules) : that.resourceRules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.excludeResourceRules, this.matchPolicy, this.namespaceSelector, this.objectSelector, this.resourceRules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty()) {
            sb.append("excludeResourceRules:");
            sb.append(this.excludeResourceRules + ",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.objectSelector != null) {
            sb.append("objectSelector:");
            sb.append(this.objectSelector + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourceRulesNestedImpl<N>
    extends NamedRuleWithOperationsFluentImpl<MatchResourcesFluent.ResourceRulesNested<N>>
    implements MatchResourcesFluent.ResourceRulesNested<N>,
    Nested<N> {
        NamedRuleWithOperationsBuilder builder;
        Integer index;

        ResourceRulesNestedImpl(Integer index, NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new NamedRuleWithOperationsBuilder(this, item);
        }

        ResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new NamedRuleWithOperationsBuilder(this);
        }

        @Override
        public N and() {
            return (N)MatchResourcesFluentImpl.this.setToResourceRules(this.index, this.builder.build());
        }

        @Override
        public N endResourceRule() {
            return this.and();
        }
    }

    class ObjectSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<MatchResourcesFluent.ObjectSelectorNested<N>>
    implements MatchResourcesFluent.ObjectSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)MatchResourcesFluentImpl.this.withObjectSelector(this.builder.build());
        }

        @Override
        public N endObjectSelector() {
            return this.and();
        }
    }

    class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<MatchResourcesFluent.NamespaceSelectorNested<N>>
    implements MatchResourcesFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)MatchResourcesFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    class ExcludeResourceRulesNestedImpl<N>
    extends NamedRuleWithOperationsFluentImpl<MatchResourcesFluent.ExcludeResourceRulesNested<N>>
    implements MatchResourcesFluent.ExcludeResourceRulesNested<N>,
    Nested<N> {
        NamedRuleWithOperationsBuilder builder;
        Integer index;

        ExcludeResourceRulesNestedImpl(Integer index, NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new NamedRuleWithOperationsBuilder(this, item);
        }

        ExcludeResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new NamedRuleWithOperationsBuilder(this);
        }

        @Override
        public N and() {
            return (N)MatchResourcesFluentImpl.this.setToExcludeResourceRules(this.index, this.builder.build());
        }

        @Override
        public N endExcludeResourceRule() {
            return this.and();
        }
    }
}

