/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchHTTPManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchHTTPManager.class);
    private CompletableFuture<HttpResponse<AsyncBody>> call;
    private volatile AsyncBody body;

    public WatchHTTPManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, () -> client.newBuilder().tag(((RequestConfigBuilder)new RequestConfigBuilder(baseOperation.getRequestConfig()).withRequestTimeout(0)).build()).readTimeout(0L, TimeUnit.MILLISECONDS).forStreaming().build());
    }

    @Override
    protected synchronized void start(URL url, Map<String, String> headers, AbstractWatchManager.WatchRequestState state) {
        HttpRequest.Builder builder = this.client.newHttpRequestBuilder().url(url);
        headers.forEach(builder::header);
        StringBuffer buffer = new StringBuffer();
        this.call = this.client.consumeBytes(builder.build(), (b, a) -> {
            for (ByteBuffer content : b) {
                for (char c : StandardCharsets.UTF_8.decode(content).array()) {
                    if (c == '\n') {
                        this.onMessage(buffer.toString(), state);
                        buffer.setLength(0);
                        continue;
                    }
                    buffer.append(c);
                }
            }
            a.consume();
        });
        this.call.whenComplete((response, t) -> {
            if (t != null) {
                logger.info("Watch connection failed. reason: {}", (Object)t.getMessage());
                this.scheduleReconnect(state);
            }
            if (response != null) {
                this.body = (AsyncBody)response.body();
                if (!response.isSuccessful()) {
                    this.body.cancel();
                    if (this.onStatus(OperationSupport.createStatus(response.code(), response.message()), state)) {
                        return;
                    }
                    this.scheduleReconnect(state);
                } else {
                    this.resetReconnectAttempts(state);
                    this.body.consume();
                    this.body.done().whenComplete((v, e) -> {
                        if (e != null) {
                            logger.info("Watch terminated unexpectedly. reason: {}", (Object)e.getMessage());
                        }
                        this.scheduleReconnect(state);
                    });
                }
            }
        });
    }

    @Override
    protected synchronized void closeCurrentRequest() {
        Optional.ofNullable(this.call).ifPresent(theFuture -> theFuture.cancel(true));
        Optional.ofNullable(this.body).ifPresent(AsyncBody::cancel);
    }
}

