/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceCompare {
    private static TypeReference<HashMap<String, Object>> TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private static final String METADATA = "metadata";
    private static final String SPEC = "spec";
    private static final String ITEMS = "items";

    private ResourceCompare() {
    }

    @Deprecated
    public static <T> boolean equals(T left, T right) {
        ObjectMapper jsonMapper = Serialization.jsonMapper();
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        Map leftJson = jsonMapper.convertValue(left, TYPE_REF);
        Map rightJson = jsonMapper.convertValue(right, TYPE_REF);
        if (left instanceof KubernetesList) {
            return ResourceCompare.compareKubernetesList(leftJson, rightJson);
        }
        return ResourceCompare.compareKubernetesResource(leftJson, rightJson);
    }

    @Deprecated
    public static boolean compareKubernetesList(Map<String, Object> leftJson, Map<String, Object> rightJson) {
        List leftItems = (List)leftJson.get(ITEMS);
        List rightItems = (List)rightJson.get(ITEMS);
        if (leftItems != null && rightItems != null) {
            if (leftItems.size() != rightItems.size()) {
                return false;
            }
            for (int i = 0; i < rightItems.size(); ++i) {
                if (ResourceCompare.compareKubernetesResource((Map)leftItems.get(i), (Map)rightItems.get(i))) continue;
                return false;
            }
        } else {
            return leftItems != null;
        }
        return true;
    }

    @Deprecated
    public static boolean compareKubernetesResource(Map<String, Object> leftJson, Map<String, Object> rightJson) {
        return ResourceCompare.isEqualMetadata(leftJson, rightJson) && ResourceCompare.isEqualSpec(leftJson, rightJson);
    }

    private static boolean isEqualMetadata(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        Map leftMetadata = (Map)leftMap.get(METADATA);
        Map rightMetadata = (Map)rightMap.get(METADATA);
        if (leftMetadata == null && rightMetadata == null) {
            return true;
        }
        if (leftMetadata != null && rightMetadata == null) {
            return true;
        }
        if (leftMetadata == null) {
            return false;
        }
        return ResourceCompare.isLeftMapSupersetOfRight(leftMetadata, rightMetadata);
    }

    private static boolean isEqualSpec(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        Map leftSpec = (Map)leftMap.get(SPEC);
        Map rightSpec = (Map)rightMap.get(SPEC);
        if (leftSpec == null && rightSpec == null) {
            return true;
        }
        if (leftSpec != null && rightSpec == null) {
            return true;
        }
        if (leftSpec == null) {
            return false;
        }
        return ResourceCompare.isLeftMapSupersetOfRight(leftSpec, rightSpec);
    }

    private static boolean isLeftMapSupersetOfRight(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        for (Map.Entry<String, Object> entry : rightMap.entrySet()) {
            if (!leftMap.containsKey(entry.getKey())) {
                return false;
            }
            if (leftMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean metadataChanged(ObjectMeta object1, ObjectMeta object2) {
        return !Objects.equals(ResourceCompare.withoutRuntimeState(object1), ResourceCompare.withoutRuntimeState(object2));
    }

    static ObjectMeta withoutRuntimeState(ObjectMeta meta) {
        if (meta == null) {
            return null;
        }
        ObjectMetaBuilder builder = new ObjectMetaBuilder(meta);
        return ((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)builder.withCreationTimestamp(null)).withDeletionTimestamp(null)).withGeneration(null)).withResourceVersion(null)).withSelfLink(null)).withUid(null)).build();
    }
}

