/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.utils.Strings;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;

public class KubernetesFactory {
    public static final String DEFAULT_KUBERNETES_MASTER = "http://localhost:8080";
    public static final String KUBERNETES_TRUST_ALL_CERIFICATES = "KUBERNETES_TRUST_CERT";
    public static final String KUBERNETES_USERNAME = "KUBERNETES_USERNAME";
    public static final String KUBERNETES_PASSWORD = "KUBERNETES_PASSWORD";
    private String address;
    private boolean trustAllCerts = false;
    private String username;
    private String password;

    public KubernetesFactory() {
        this(null);
    }

    public KubernetesFactory(String address) {
        this.address = address;
        if (KubernetesFactory.isEmpty(address)) {
            this.address = this.findKubernetesMaster();
        }
        this.init();
    }

    protected String findKubernetesMaster() {
        return KubernetesFactory.resolveHttpKubernetesMaster();
    }

    private void init() {
        if (System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES) != null) {
            this.trustAllCerts = Boolean.valueOf(System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES));
        }
        if (System.getenv(KUBERNETES_USERNAME) != null) {
            this.username = System.getenv(KUBERNETES_USERNAME);
        }
        if (System.getenv(KUBERNETES_PASSWORD) != null) {
            this.password = System.getenv(KUBERNETES_PASSWORD);
        }
    }

    public String toString() {
        return "KubernetesFactory{" + this.address + '}';
    }

    public Kubernetes createKubernetes() {
        return this.createWebClient(Kubernetes.class);
    }

    public KubernetesExtensions createKubernetesExtensions() {
        return this.createWebClient(KubernetesExtensions.class);
    }

    public <T> T createWebClient(Class<T> clientType) {
        List<Object> providers = this.createProviders();
        WebClient webClient = WebClient.create((String)this.address, providers);
        this.configureAuthDetails(webClient);
        if (this.trustAllCerts) {
            this.disableSslChecks(webClient);
        }
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    protected List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add((Object)new PlainTextJacksonProvider(objectMapper, annotationsToUse));
        return providers;
    }

    public String getKubernetesMaster() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (KubernetesFactory.isEmpty(address)) {
            this.findKubernetesMaster();
        }
    }

    protected static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String resolveHttpKubernetesMaster() {
        String dockerHost = KubernetesFactory.resolveKubernetesMaster();
        if (dockerHost.startsWith("tcp:")) {
            return "http:" + dockerHost.substring(4);
        }
        return dockerHost;
    }

    public static String resolveKubernetesMaster() {
        String dockerHost = System.getenv("KUBERNETES_MASTER");
        if (KubernetesFactory.isEmpty(dockerHost)) {
            dockerHost = System.getProperty("kubernetes.master");
        }
        if (!KubernetesFactory.isEmpty(dockerHost)) {
            return dockerHost;
        }
        return DEFAULT_KUBERNETES_MASTER;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    private void configureAuthDetails(WebClient webClient) {
        if (Strings.isNotBlank((String)this.username) && Strings.isNotBlank((String)this.password)) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            conduit.getAuthorization().setUserName(this.username);
            conduit.getAuthorization().setPassword(this.password);
        }
    }

    private void disableSslChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        params.setTrustManagers(new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }});
        params.setDisableCNCheck(true);
    }

    @Provider
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public static class PlainTextJacksonProvider
    extends JacksonJaxbJsonProvider {
        public PlainTextJacksonProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
            super(mapper, annotationsToUse);
        }

        protected boolean hasMatchingMediaType(MediaType mediaType) {
            boolean answer = super.hasMatchingMediaType(mediaType);
            String type = mediaType.getType();
            String subtype = mediaType.getSubtype();
            if (!answer && type.equals("text")) {
                answer = super.hasMatchingMediaType(MediaType.APPLICATION_JSON_TYPE);
            }
            return answer;
        }
    }
}

