package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HasMetadata} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHasMetadataAssert<S extends AbstractHasMetadataAssert<S, A>, A extends HasMetadata> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHasMetadataAssert}</code> to make assertions on actual HasMetadata.
   * @param actual the HasMetadata we want to make assertions on.
   */
  protected AbstractHasMetadataAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HasMetadata's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual HasMetadata's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HasMetadata's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual HasMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
