package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubernetesKind} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesKindAssert<S extends AbstractKubernetesKindAssert<S, A>, A extends KubernetesKind> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesKindAssert}</code> to make assertions on actual KubernetesKind.
   * @param actual the KubernetesKind we want to make assertions on.
   */
  protected AbstractKubernetesKindAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesKind's type is equal to the given one.
   * @param type the given type to compare the actual KubernetesKind's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesKind's type is not equal to the given one.
   */
  public S hasType(Class type) {
    // check that actual KubernetesKind we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Class actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
