package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Secret} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretAssert<S extends AbstractSecretAssert<S, A>, A extends Secret> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretAssert}</code> to make assertions on actual Secret.
   * @param actual the Secret we want to make assertions on.
   */
  protected AbstractSecretAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Secret's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Secret's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Secret's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Secret's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Secret.ApiVersion apiVersion) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Secret.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Secret's data is equal to the given one.
   * @param data the given data to compare the actual Secret's data to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's data is not equal to the given one.
   */
  public S hasData(java.util.Map data) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected data of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualData = actual.getData();
    if (!Objects.areEqual(actualData, data)) {
      failWithMessage(assertjErrorMessage, actual, data, actualData);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Secret's kind is equal to the given one.
   * @param kind the given kind to compare the actual Secret's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Secret's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual Secret's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Secret's type is equal to the given one.
   * @param type the given type to compare the actual Secret's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Secret's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual Secret we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
