package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecretVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretVolumeSourceAssert<S extends AbstractSecretVolumeSourceAssert<S, A>, A extends SecretVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretVolumeSourceAssert}</code> to make assertions on actual SecretVolumeSource.
   * @param actual the SecretVolumeSource we want to make assertions on.
   */
  protected AbstractSecretVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecretVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecretVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecretVolumeSource's secretName is equal to the given one.
   * @param secretName the given secretName to compare the actual SecretVolumeSource's secretName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretVolumeSource's secretName is not equal to the given one.
   */
  public S hasSecretName(String secretName) {
    // check that actual SecretVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretName = actual.getSecretName();
    if (!Objects.areEqual(actualSecretName, secretName)) {
      failWithMessage(assertjErrorMessage, actual, secretName, actualSecretName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
