package io.fabric8.kubernetes.api.model.config;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AuthInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAuthInfoAssert<S extends AbstractAuthInfoAssert<S, A>, A extends AuthInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAuthInfoAssert}</code> to make assertions on actual AuthInfo.
   * @param actual the AuthInfo we want to make assertions on.
   */
  protected AbstractAuthInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AuthInfo's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual AuthInfo's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo's clientCertificate is equal to the given one.
   * @param clientCertificate the given clientCertificate to compare the actual AuthInfo's clientCertificate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's clientCertificate is not equal to the given one.
   */
  public S hasClientCertificate(String clientCertificate) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clientCertificate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientCertificate = actual.getClientCertificate();
    if (!Objects.areEqual(actualClientCertificate, clientCertificate)) {
      failWithMessage(assertjErrorMessage, actual, clientCertificate, actualClientCertificate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo's clientCertificateData contains the given Integer elements.
   * @param clientCertificateData the given elements that should be contained in actual AuthInfo's clientCertificateData.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's clientCertificateData does not contain all given Integer elements.
   */
  public S hasClientCertificateData(Integer... clientCertificateData) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // check that given Integer varargs is not null.
    if (clientCertificateData == null) throw new AssertionError("Expecting clientCertificateData parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getClientCertificateData(), clientCertificateData);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo has no clientCertificateData.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's clientCertificateData is not empty.
   */
  public S hasNoClientCertificateData() {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have clientCertificateData but had :\n  <%s>";
    
    // check
    if (actual.getClientCertificateData().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getClientCertificateData());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual AuthInfo's clientKey is equal to the given one.
   * @param clientKey the given clientKey to compare the actual AuthInfo's clientKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's clientKey is not equal to the given one.
   */
  public S hasClientKey(String clientKey) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clientKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientKey = actual.getClientKey();
    if (!Objects.areEqual(actualClientKey, clientKey)) {
      failWithMessage(assertjErrorMessage, actual, clientKey, actualClientKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo's clientKeyData contains the given Integer elements.
   * @param clientKeyData the given elements that should be contained in actual AuthInfo's clientKeyData.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's clientKeyData does not contain all given Integer elements.
   */
  public S hasClientKeyData(Integer... clientKeyData) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // check that given Integer varargs is not null.
    if (clientKeyData == null) throw new AssertionError("Expecting clientKeyData parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getClientKeyData(), clientKeyData);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo has no clientKeyData.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's clientKeyData is not empty.
   */
  public S hasNoClientKeyData() {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have clientKeyData but had :\n  <%s>";
    
    // check
    if (actual.getClientKeyData().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getClientKeyData());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual AuthInfo's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual AuthInfo's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) throw new AssertionError("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfo's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual AuthInfo's password is equal to the given one.
   * @param password the given password to compare the actual AuthInfo's password to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's password is not equal to the given one.
   */
  public S hasPassword(String password) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected password of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPassword = actual.getPassword();
    if (!Objects.areEqual(actualPassword, password)) {
      failWithMessage(assertjErrorMessage, actual, password, actualPassword);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo's token is equal to the given one.
   * @param token the given token to compare the actual AuthInfo's token to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's token is not equal to the given one.
   */
  public S hasToken(String token) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected token of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualToken = actual.getToken();
    if (!Objects.areEqual(actualToken, token)) {
      failWithMessage(assertjErrorMessage, actual, token, actualToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfo's username is equal to the given one.
   * @param username the given username to compare the actual AuthInfo's username to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfo's username is not equal to the given one.
   */
  public S hasUsername(String username) {
    // check that actual AuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected username of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUsername = actual.getUsername();
    if (!Objects.areEqual(actualUsername, username)) {
      failWithMessage(assertjErrorMessage, actual, username, actualUsername);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
