package io.fabric8.kubernetes.api.model.errors;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link StatusError} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusErrorAssert<S extends AbstractStatusErrorAssert<S, A>, A extends StatusError> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusErrorAssert}</code> to make assertions on actual StatusError.
   * @param actual the StatusError we want to make assertions on.
   */
  protected AbstractStatusErrorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual StatusError's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual StatusError's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusError's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual StatusError we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusError's errStatus is equal to the given one.
   * @param errStatus the given errStatus to compare the actual StatusError's errStatus to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusError's errStatus is not equal to the given one.
   */
  public S hasErrStatus(io.fabric8.kubernetes.api.model.base.Status errStatus) {
    // check that actual StatusError we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected errStatus of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.base.Status actualErrStatus = actual.getErrStatus();
    if (!Objects.areEqual(actualErrStatus, errStatus)) {
      failWithMessage(assertjErrorMessage, actual, errStatus, actualErrStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
