/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ListMetaBuilder
extends ListMetaFluent<ListMetaBuilder>
implements VisitableBuilder<ListMeta, ListMetaBuilder> {
    ListMetaFluent<?> fluent;

    public ListMetaBuilder() {
        this(new ListMeta());
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent) {
        this(fluent, new ListMeta());
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, ListMeta instance) {
        this.fluent = fluent;
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
    }

    public ListMetaBuilder(ListMeta instance) {
        this.fluent = this;
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
    }

    public ListMeta build() {
        ListMeta buildable = new ListMeta(this.fluent.getResourceVersion(), this.fluent.getSelfLink());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

