/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodListFluent<T extends PodListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    PodList.ApiVersion apiVersion;
    List<VisitableBuilder<Pod, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PodList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(PodList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToItems(Pod item) {
        if (item != null) {
            PodBuilder builder = new PodBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)((Object)this);
    }

    public List<Pod> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<Pod> items) {
        this.items.clear();
        if (items != null) {
            for (Pod item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder = new ListMetaBuilder(this);

        public N and() {
            return (N)PodListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNested<N>
    extends PodFluent<ItemsNested<N>>
    implements Nested<N> {
        private final PodBuilder builder = new PodBuilder(this);

        public N endItem() {
            return this.and();
        }

        public N and() {
            return (N)PodListFluent.this.addToItems(this.builder.build());
        }
    }
}

