/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.base;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.base.StatusCause;
import io.fabric8.kubernetes.api.model.base.StatusCauseFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusCauseBuilder
extends StatusCauseFluent<StatusCauseBuilder>
implements VisitableBuilder<StatusCause, StatusCauseBuilder> {
    StatusCauseFluent<?> fluent;

    public StatusCauseBuilder() {
        this(new StatusCause());
    }

    public StatusCauseBuilder(StatusCauseFluent<?> fluent) {
        this(fluent, new StatusCause());
    }

    public StatusCauseBuilder(StatusCauseFluent<?> fluent, StatusCause instance) {
        this.fluent = fluent;
        fluent.withField(instance.getField());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
    }

    public StatusCauseBuilder(StatusCause instance) {
        this.fluent = this;
        this.withField(instance.getField());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
    }

    public StatusCause build() {
        StatusCause buildable = new StatusCause(this.fluent.getField(), this.fluent.getMessage(), this.fluent.getReason());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

