/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CephFSVolumeSourceFluentImpl<T extends CephFSVolumeSourceFluent<T>>
extends BaseFluent<T>
implements CephFSVolumeSourceFluent<T> {
    List<String> monitors = new ArrayList<String>();
    String path;
    Boolean readOnly;
    String secretFile;
    VisitableBuilder<LocalObjectReference, ?> secretRef;
    String user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public CephFSVolumeSourceFluentImpl() {
    }

    public CephFSVolumeSourceFluentImpl(CephFSVolumeSource instance) {
        this.withMonitors(instance.getMonitors());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretFile(instance.getSecretFile());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public T addToMonitors(String ... items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromMonitors(String ... items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public T withMonitors(List<String> monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withMonitors(String ... monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public T withPath(String path) {
        this.path = path;
        return (T)this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public T withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    @Override
    public String getSecretFile() {
        return this.secretFile;
    }

    @Override
    public T withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (T)this;
    }

    @Override
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? (LocalObjectReference)this.secretRef.build() : null;
    }

    @Override
    public T withSecretRef(LocalObjectReference secretRef) {
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (T)this;
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<T> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<T> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<T> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public T withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public T withUser(String user) {
        this.user = user;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl)o;
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretFile != null ? !this.secretFile.equals(that.secretFile) : that.secretFile != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CephFSVolumeSourceFluent.SecretRefNested<N>>
    implements CephFSVolumeSourceFluent.SecretRefNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)CephFSVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }
    }
}

