/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableNodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeDaemonEndpointsBuilder
extends NodeDaemonEndpointsFluentImpl<NodeDaemonEndpointsBuilder>
implements VisitableBuilder<NodeDaemonEndpoints, NodeDaemonEndpointsBuilder> {
    NodeDaemonEndpointsFluent<?> fluent;

    public NodeDaemonEndpointsBuilder() {
        this(new NodeDaemonEndpoints());
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent) {
        this(fluent, new NodeDaemonEndpoints());
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent, NodeDaemonEndpoints instance) {
        this.fluent = fluent;
        fluent.withKubeletEndpoint(instance.getKubeletEndpoint());
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance) {
        this.fluent = this;
        this.withKubeletEndpoint(instance.getKubeletEndpoint());
    }

    public EditableNodeDaemonEndpoints build() {
        EditableNodeDaemonEndpoints buildable = new EditableNodeDaemonEndpoints(this.fluent.getKubeletEndpoint());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDaemonEndpointsBuilder that = (NodeDaemonEndpointsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

