/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodAssert;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListAssert;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListAssert;
import io.fabric8.kubernetes.api.model.ServiceSpecAssert;
import io.fabric8.kubernetes.assertions.KubernetesAssert;
import io.fabric8.kubernetes.assertions.PodsAssert;
import io.fabric8.kubernetes.assertions.internal.Assertions;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.List;
import org.assertj.core.api.ListAssert;

public class KubernetesNamespaceAssert
extends KubernetesAssert {
    private final KubernetesClient client;
    private final String namespace;

    public KubernetesNamespaceAssert(KubernetesClient client, String namespace) {
        super(client);
        this.client = client;
        this.namespace = namespace;
    }

    public String namespace() {
        return this.namespace;
    }

    @Override
    public PodsAssert podList() {
        PodList pods = (PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).list();
        return this.podList(pods);
    }

    @Override
    public PodsAssert pods() {
        return this.pods(this.namespace);
    }

    @Override
    public ReplicationControllerListAssert replicationControllerList() {
        ReplicationControllerList replicationControllers = (ReplicationControllerList)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(this.namespace)).list();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    @Override
    public ListAssert<ReplicationController> replicationControllers() {
        return this.replicationControllers(this.namespace);
    }

    @Override
    public ServiceListAssert serviceList() {
        ServiceList serviceList = (ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace)).list();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    @Override
    public ListAssert<Service> services() {
        return this.services(this.namespace);
    }

    public Pod podForReplicationController(String replicationControllerName) {
        PodsAssert forgePodsAssert = this.podsForReplicationController(replicationControllerName).runningStatus();
        ((ListAssert)forgePodsAssert.describedAs("pods for " + replicationControllerName, new Object[0])).isNotEmpty();
        List pods = forgePodsAssert.get();
        return (Pod)pods.get(0);
    }

    public PodsAssert podsForReplicationController(String name) {
        ReplicationController replicationController = this.getReplicationController(name, this.namespace);
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForService(String name) {
        Service service = this.getService(name, this.namespace);
        return this.podsForService(service);
    }

    public ReplicationControllerAssert replicationController(String name) {
        return Assertions.assertThat(this.getReplicationController(name, this.namespace));
    }

    public ServiceAssert service(String name) {
        return Assertions.assertThat(this.getService(name, this.namespace));
    }

    public void hasServicePort(String serviceName, int port) {
        this.hasServicePort(serviceName, this.namespace, port);
    }

    public ServiceSpecAssert serviceSpec(String serviceName) {
        return Assertions.assertThat(this.getServiceSpec(serviceName, this.namespace));
    }

    public PodAssert pod(String podName) {
        return Assertions.assertThat(this.getPod(podName, this.namespace));
    }
}

