/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageSourceFluentImpl<T extends ImageSourceFluent<T>>
extends BaseFluent<T>
implements ImageSourceFluent<T> {
    VisitableBuilder<ObjectReference, ?> from;
    List<VisitableBuilder<ImageSourcePath, ?>> paths = new ArrayList();
    VisitableBuilder<LocalObjectReference, ?> pullSecret;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageSourceFluentImpl() {
    }

    public ImageSourceFluentImpl(ImageSource instance) {
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public T withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (T)this;
    }

    @Override
    public ImageSourceFluent.FromNested<T> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public ImageSourceFluent.FromNested<T> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.FromNested<T> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public T addToPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.add(builder);
            this.paths.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.remove(builder);
            this.paths.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ImageSourcePath> getPaths() {
        return this.build(this.paths);
    }

    @Override
    public T withPaths(List<ImageSourcePath> paths) {
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withPaths(ImageSourcePath ... paths) {
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (T)this;
    }

    @Override
    public ImageSourceFluent.PathsNested<T> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public ImageSourceFluent.PathsNested<T> addNewPathLike(ImageSourcePath item) {
        return new PathsNestedImpl(item);
    }

    @Override
    public T addNewPath(String destinationDir, String sourcePath) {
        return this.addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    @Override
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? (LocalObjectReference)this.pullSecret.build() : null;
    }

    @Override
    public T withPullSecret(LocalObjectReference pullSecret) {
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (T)this;
    }

    @Override
    public ImageSourceFluent.PullSecretNested<T> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public ImageSourceFluent.PullSecretNested<T> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.PullSecretNested<T> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public T withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageSourceFluentImpl that = (ImageSourceFluentImpl)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ImageSourceFluent.PullSecretNested<N>>
    implements ImageSourceFluent.PullSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class PathsNestedImpl<N>
    extends ImageSourcePathFluentImpl<ImageSourceFluent.PathsNested<N>>
    implements ImageSourceFluent.PathsNested<N> {
        private final ImageSourcePathBuilder builder;

        PathsNestedImpl() {
            this.builder = new ImageSourcePathBuilder(this);
        }

        PathsNestedImpl(ImageSourcePath item) {
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.addToPaths(this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<ImageSourceFluent.FromNested<N>>
    implements ImageSourceFluent.FromNested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withFrom(this.builder.build());
        }
    }
}

