/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleBuilder;
import io.fabric8.openshift.api.model.PolicyRuleFluentImpl;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoleFluentImpl<T extends RoleFluent<T>>
extends BaseFluent<T>
implements RoleFluent<T> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<PolicyRule, ?>> rules = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public RoleFluentImpl() {
    }

    public RoleFluentImpl(Role instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public RoleFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToRules(PolicyRule ... items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromRules(PolicyRule ... items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.remove(builder);
            this.rules.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<PolicyRule> getRules() {
        return this.build(this.rules);
    }

    @Override
    public T withRules(List<PolicyRule> rules) {
        this.rules.clear();
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRules(PolicyRule ... rules) {
        this.rules.clear();
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (T)this;
    }

    @Override
    public RoleFluent.RulesNested<T> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public RoleFluent.RulesNested<T> addNewRuleLike(PolicyRule item) {
        return new RulesNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleFluentImpl that = (RoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RulesNestedImpl<N>
    extends PolicyRuleFluentImpl<RoleFluent.RulesNested<N>>
    implements RoleFluent.RulesNested<N> {
        private final PolicyRuleBuilder builder;

        RulesNestedImpl() {
            this.builder = new PolicyRuleBuilder(this);
        }

        RulesNestedImpl(PolicyRule item) {
            this.builder = new PolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RoleFluentImpl.this.addToRules(this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleFluent.MetadataNested<N>>
    implements RoleFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

