/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableSourceBuildStrategy;
import io.fabric8.openshift.api.model.SourceBuildStrategy;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SourceBuildStrategyBuilder
extends SourceBuildStrategyFluentImpl<SourceBuildStrategyBuilder>
implements VisitableBuilder<SourceBuildStrategy, SourceBuildStrategyBuilder> {
    SourceBuildStrategyFluent<?> fluent;

    public SourceBuildStrategyBuilder() {
        this(new SourceBuildStrategy());
    }

    public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent) {
        this(fluent, new SourceBuildStrategy());
    }

    public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent, SourceBuildStrategy instance) {
        this.fluent = fluent;
        fluent.withEnv(instance.getEnv());
        fluent.withForcePull(instance.getForcePull());
        fluent.withFrom(instance.getFrom());
        fluent.withIncremental(instance.getIncremental());
        fluent.withPullSecret(instance.getPullSecret());
        fluent.withScripts(instance.getScripts());
    }

    public SourceBuildStrategyBuilder(SourceBuildStrategy instance) {
        this.fluent = this;
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withIncremental(instance.getIncremental());
        this.withPullSecret(instance.getPullSecret());
        this.withScripts(instance.getScripts());
    }

    public EditableSourceBuildStrategy build() {
        EditableSourceBuildStrategy buildable = new EditableSourceBuildStrategy(this.fluent.getEnv(), this.fluent.isForcePull(), this.fluent.getFrom(), this.fluent.isIncremental(), this.fluent.getPullSecret(), this.fluent.getScripts());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceBuildStrategyBuilder that = (SourceBuildStrategyBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

