package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerStateTerminated} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateTerminatedAssert<S extends AbstractContainerStateTerminatedAssert<S, A>, A extends ContainerStateTerminated> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateTerminatedAssert}</code> to make assertions on actual ContainerStateTerminated.
   * @param actual the ContainerStateTerminated we want to make assertions on.
   */
  protected AbstractContainerStateTerminatedAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property containerID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert containerID()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainerID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerID"));
  }


  /**
   * Verifies that the actual ContainerStateTerminated's exitCode is equal to the given one.
   * @param exitCode the given exitCode to compare the actual ContainerStateTerminated's exitCode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminated's exitCode is not equal to the given one.
   */
  public S hasExitCode(Integer exitCode) {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting exitCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualExitCode = actual.getExitCode();
    if (!Objects.areEqual(actualExitCode, exitCode)) {
      failWithMessage(assertjErrorMessage, actual, exitCode, actualExitCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property finishedAt so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert finishedAt()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFinishedAt()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "finishedAt"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Verifies that the actual ContainerStateTerminated's signal is equal to the given one.
   * @param signal the given signal to compare the actual ContainerStateTerminated's signal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminated's signal is not equal to the given one.
   */
  public S hasSignal(Integer signal) {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting signal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSignal = actual.getSignal();
    if (!Objects.areEqual(actualSignal, signal)) {
      failWithMessage(assertjErrorMessage, actual, signal, actualSignal);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property startedAt so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startedAt()  {
    // check that actual ContainerStateTerminated we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartedAt()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startedAt"));
  }


}
