package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeleteOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeleteOptionsAssert<S extends AbstractDeleteOptionsAssert<S, A>, A extends DeleteOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeleteOptionsAssert}</code> to make assertions on actual DeleteOptions.
   * @param actual the DeleteOptions we want to make assertions on.
   */
  protected AbstractDeleteOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeleteOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual DeleteOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Verifies that the actual DeleteOptions's gracePeriodSeconds is equal to the given one.
   * @param gracePeriodSeconds the given gracePeriodSeconds to compare the actual DeleteOptions's gracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeleteOptions's gracePeriodSeconds is not equal to the given one.
   */
  public S hasGracePeriodSeconds(Long gracePeriodSeconds) {
    // check that actual DeleteOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting gracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGracePeriodSeconds = actual.getGracePeriodSeconds();
    if (!Objects.areEqual(actualGracePeriodSeconds, gracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, gracePeriodSeconds, actualGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual DeleteOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property preconditions so that assertions can be done on it
   */
  public PreconditionsAssert preconditions()  {
    // check that actual DeleteOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PreconditionsAssert) assertThat(actual.getPreconditions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preconditions"));
  }


}
