package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link FlexVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractFlexVolumeSourceAssert<S extends AbstractFlexVolumeSourceAssert<S, A>, A extends FlexVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFlexVolumeSourceAssert}</code> to make assertions on actual FlexVolumeSource.
   * @param actual the FlexVolumeSource we want to make assertions on.
   */
  protected AbstractFlexVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property driver so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert driver()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDriver()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "driver"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property options so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert options()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "options"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public LocalObjectReferenceAssert secretRef()  {
    // check that actual FlexVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalObjectReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


}
