package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link KubernetesKind} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesKindAssert<S extends AbstractKubernetesKindAssert<S, A>, A extends KubernetesKind> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesKindAssert}</code> to make assertions on actual KubernetesKind.
   * @param actual the KubernetesKind we want to make assertions on.
   */
  protected AbstractKubernetesKindAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.ClassAssert type()  {
    // check that actual KubernetesKind we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.ClassAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
