package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link MetadataVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMetadataVolumeSourceAssert<S extends AbstractMetadataVolumeSourceAssert<S, A>, A extends MetadataVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMetadataVolumeSourceAssert}</code> to make assertions on actual MetadataVolumeSource.
   * @param actual the MetadataVolumeSource we want to make assertions on.
   */
  protected AbstractMetadataVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual MetadataVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<MetadataFile, MetadataFileAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<MetadataFile, MetadataFileAssert> assertFactory = new AssertFactory<MetadataFile, MetadataFileAssert>() {
      public MetadataFileAssert createAssert(MetadataFile t) {
        return (MetadataFileAssert) assertThat(t);
      }
    };
    NavigationListAssert<MetadataFile, MetadataFileAssert> answer = new NavigationListAssert<MetadataFile, MetadataFileAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


}
