package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PersistentVolume} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeAssert<S extends AbstractPersistentVolumeAssert<S, A>, A extends PersistentVolume> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeAssert}</code> to make assertions on actual PersistentVolume.
   * @param actual the PersistentVolume we want to make assertions on.
   */
  protected AbstractPersistentVolumeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property spec so that assertions can be done on it
   */
  public PersistentVolumeSpecAssert spec()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeSpecAssert) assertThat(actual.getSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "spec"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public PersistentVolumeStatusAssert status()  {
    // check that actual PersistentVolume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeStatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


}
