package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Preconditions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPreconditionsAssert<S extends AbstractPreconditionsAssert<S, A>, A extends Preconditions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPreconditionsAssert}</code> to make assertions on actual Preconditions.
   * @param actual the Preconditions we want to make assertions on.
   */
  protected AbstractPreconditionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Preconditions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual Preconditions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
