package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link WatchEvent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWatchEventAssert<S extends AbstractWatchEventAssert<S, A>, A extends WatchEvent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWatchEventAssert}</code> to make assertions on actual WatchEvent.
   * @param actual the WatchEvent we want to make assertions on.
   */
  protected AbstractWatchEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property object so that assertions can be done on it
   */
  public HasMetadataAssert object()  {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HasMetadataAssert) assertThat(actual.getObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "object"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
