package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link HTTPIngressRuleValue} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPIngressRuleValueAssert<S extends AbstractHTTPIngressRuleValueAssert<S, A>, A extends HTTPIngressRuleValue> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPIngressRuleValueAssert}</code> to make assertions on actual HTTPIngressRuleValue.
   * @param actual the HTTPIngressRuleValue we want to make assertions on.
   */
  protected AbstractHTTPIngressRuleValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual HTTPIngressRuleValue we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property paths so that assertions can be done on it
   */
  public NavigationListAssert<HTTPIngressPath, HTTPIngressPathAssert> paths()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HTTPIngressPath, HTTPIngressPathAssert> assertFactory = new AssertFactory<HTTPIngressPath, HTTPIngressPathAssert>() {
      public HTTPIngressPathAssert createAssert(HTTPIngressPath t) {
        return (HTTPIngressPathAssert) assertThat(t);
      }
    };
    NavigationListAssert<HTTPIngressPath, HTTPIngressPathAssert> answer = new NavigationListAssert<HTTPIngressPath, HTTPIngressPathAssert>(actual.getPaths(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "paths"));
    return answer;
  }


}
