package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link IngressRule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressRuleAssert<S extends AbstractIngressRuleAssert<S, A>, A extends IngressRule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressRuleAssert}</code> to make assertions on actual IngressRule.
   * @param actual the IngressRule we want to make assertions on.
   */
  protected AbstractIngressRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IngressRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual IngressRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


  /**
   * Navigates to the property http so that assertions can be done on it
   */
  public HTTPIngressRuleValueAssert http()  {
    // check that actual IngressRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HTTPIngressRuleValueAssert) assertThat(actual.getHttp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "http"));
  }


}
