package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link IngressStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressStatusAssert<S extends AbstractIngressStatusAssert<S, A>, A extends IngressStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressStatusAssert}</code> to make assertions on actual IngressStatus.
   * @param actual the IngressStatus we want to make assertions on.
   */
  protected AbstractIngressStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IngressStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property loadBalancer so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert loadBalancer()  {
    // check that actual IngressStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert) assertThat(actual.getLoadBalancer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancer"));
  }


}
