package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ClusterPolicyBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterPolicyBindingAssert<S extends AbstractClusterPolicyBindingAssert<S, A>, A extends ClusterPolicyBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterPolicyBindingAssert}</code> to make assertions on actual ClusterPolicyBinding.
   * @param actual the ClusterPolicyBinding we want to make assertions on.
   */
  protected AbstractClusterPolicyBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property lastModified so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastModified()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastModified()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastModified"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property policyRef so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert policyRef()  {
    // check that actual ClusterPolicyBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getPolicyRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "policyRef"));
  }


  /**
   * Navigates to the property roleBindings so that assertions can be done on it
   */
  public NavigationListAssert<NamedClusterRoleBinding, NamedClusterRoleBindingAssert> roleBindings()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedClusterRoleBinding, NamedClusterRoleBindingAssert> assertFactory = new AssertFactory<NamedClusterRoleBinding, NamedClusterRoleBindingAssert>() {
      public NamedClusterRoleBindingAssert createAssert(NamedClusterRoleBinding t) {
        return (NamedClusterRoleBindingAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedClusterRoleBinding, NamedClusterRoleBindingAssert> answer = new NavigationListAssert<NamedClusterRoleBinding, NamedClusterRoleBindingAssert>(actual.getRoleBindings(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBindings"));
    return answer;
  }


}
