package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link GitBuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitBuildSourceAssert<S extends AbstractGitBuildSourceAssert<S, A>, A extends GitBuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitBuildSourceAssert}</code> to make assertions on actual GitBuildSource.
   * @param actual the GitBuildSource we want to make assertions on.
   */
  protected AbstractGitBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property httpProxy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert httpProxy()  {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHttpProxy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "httpProxy"));
  }


  /**
   * Navigates to the property httpsProxy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert httpsProxy()  {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHttpsProxy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "httpsProxy"));
  }


  /**
   * Navigates to the property ref so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert ref()  {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ref"));
  }


  /**
   * Navigates to the property uri so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uri()  {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUri()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uri"));
  }


}
