package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Image} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageAssert<S extends AbstractImageAssert<S, A>, A extends Image> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageAssert}</code> to make assertions on actual Image.
   * @param actual the Image we want to make assertions on.
   */
  protected AbstractImageAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property dockerImageLayers so that assertions can be done on it
   */
  public NavigationListAssert<ImageLayer, ImageLayerAssert> dockerImageLayers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageLayer, ImageLayerAssert> assertFactory = new AssertFactory<ImageLayer, ImageLayerAssert>() {
      public ImageLayerAssert createAssert(ImageLayer t) {
        return (ImageLayerAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageLayer, ImageLayerAssert> answer = new NavigationListAssert<ImageLayer, ImageLayerAssert>(actual.getDockerImageLayers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageLayers"));
    return answer;
  }


  /**
   * Navigates to the property dockerImageManifest so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageManifest()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageManifest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageManifest"));
  }


  /**
   * Navigates to the property dockerImageMetadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert dockerImageMetadata()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getDockerImageMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageMetadata"));
  }


  /**
   * Navigates to the property dockerImageMetadataVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageMetadataVersion()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageMetadataVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageMetadataVersion"));
  }


  /**
   * Navigates to the property dockerImageReference so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageReference()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageReference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageReference"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual Image we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
