package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageChangeTrigger} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageChangeTriggerAssert<S extends AbstractImageChangeTriggerAssert<S, A>, A extends ImageChangeTrigger> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageChangeTriggerAssert}</code> to make assertions on actual ImageChangeTrigger.
   * @param actual the ImageChangeTrigger we want to make assertions on.
   */
  protected AbstractImageChangeTriggerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageChangeTrigger we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual ImageChangeTrigger we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property lastTriggeredImageID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastTriggeredImageID()  {
    // check that actual ImageChangeTrigger we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastTriggeredImageID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTriggeredImageID"));
  }


}
