package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageSourcePath} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageSourcePathAssert<S extends AbstractImageSourcePathAssert<S, A>, A extends ImageSourcePath> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageSourcePathAssert}</code> to make assertions on actual ImageSourcePath.
   * @param actual the ImageSourcePath we want to make assertions on.
   */
  protected AbstractImageSourcePathAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageSourcePath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property destinationDir so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert destinationDir()  {
    // check that actual ImageSourcePath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDestinationDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "destinationDir"));
  }


  /**
   * Navigates to the property sourcePath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert sourcePath()  {
    // check that actual ImageSourcePath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSourcePath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sourcePath"));
  }


}
