package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link OAuthClientAuthorization} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthClientAuthorizationAssert<S extends AbstractOAuthClientAuthorizationAssert<S, A>, A extends OAuthClientAuthorization> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthClientAuthorizationAssert}</code> to make assertions on actual OAuthClientAuthorization.
   * @param actual the OAuthClientAuthorization we want to make assertions on.
   */
  protected AbstractOAuthClientAuthorizationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property clientName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientName()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientName"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property scopes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> scopes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getScopes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopes"));
    return answer;
  }


  /**
   * Navigates to the property userName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert userName()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUserName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userName"));
  }


  /**
   * Navigates to the property userUID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert userUID()  {
    // check that actual OAuthClientAuthorization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUserUID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userUID"));
  }


}
