package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PolicyRule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyRuleAssert<S extends AbstractPolicyRuleAssert<S, A>, A extends PolicyRule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyRuleAssert}</code> to make assertions on actual PolicyRule.
   * @param actual the PolicyRule we want to make assertions on.
   */
  protected AbstractPolicyRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiGroups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> apiGroups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getApiGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiGroups"));
    return answer;
  }


  /**
   * Navigates to the property attributeRestrictions so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert attributeRestrictions()  {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getAttributeRestrictions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attributeRestrictions"));
  }


  /**
   * Navigates to the property nonResourceURLs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> nonResourceURLs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNonResourceURLs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nonResourceURLs"));
    return answer;
  }


  /**
   * Navigates to the property resourceNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> resourceNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getResourceNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceNames"));
    return answer;
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> resources()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getResources(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
    return answer;
  }


  /**
   * Navigates to the property verbs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> verbs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getVerbs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "verbs"));
    return answer;
  }


}
