package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link TagEvent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagEventAssert<S extends AbstractTagEventAssert<S, A>, A extends TagEvent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagEventAssert}</code> to make assertions on actual TagEvent.
   * @param actual the TagEvent we want to make assertions on.
   */
  protected AbstractTagEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property created so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert created()  {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCreated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "created"));
  }


  /**
   * Navigates to the property dockerImageReference so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageReference()  {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageReference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageReference"));
  }


  /**
   * Verifies that the actual TagEvent's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagEvent's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEvent's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


}
