/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SELinuxOptionsBuilder
extends SELinuxOptionsFluentImpl<SELinuxOptionsBuilder>
implements VisitableBuilder<SELinuxOptions, SELinuxOptionsBuilder> {
    SELinuxOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SELinuxOptionsBuilder() {
        this(true);
    }

    public SELinuxOptionsBuilder(Boolean validationEnabled) {
        this(new SELinuxOptions(), validationEnabled);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SELinuxOptions(), validationEnabled);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, SELinuxOptions instance) {
        this(fluent, instance, true);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, SELinuxOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLevel(instance.getLevel());
        fluent.withRole(instance.getRole());
        fluent.withType(instance.getType());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public SELinuxOptionsBuilder(SELinuxOptions instance) {
        this(instance, (Boolean)true);
    }

    public SELinuxOptionsBuilder(SELinuxOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLevel(instance.getLevel());
        this.withRole(instance.getRole());
        this.withType(instance.getType());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public SELinuxOptions build() {
        SELinuxOptions buildable = new SELinuxOptions(this.fluent.getLevel(), this.fluent.getRole(), this.fluent.getType(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SELinuxOptionsBuilder that = (SELinuxOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

