/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluent;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildPostCommitSpecBuilder
extends BuildPostCommitSpecFluentImpl<BuildPostCommitSpecBuilder>
implements VisitableBuilder<BuildPostCommitSpec, BuildPostCommitSpecBuilder> {
    BuildPostCommitSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BuildPostCommitSpecBuilder() {
        this(true);
    }

    public BuildPostCommitSpecBuilder(Boolean validationEnabled) {
        this(new BuildPostCommitSpec(), validationEnabled);
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildPostCommitSpec(), validationEnabled);
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent, BuildPostCommitSpec instance) {
        this(fluent, instance, true);
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent, BuildPostCommitSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArgs(instance.getArgs());
        fluent.withCommand(instance.getCommand());
        fluent.withScript(instance.getScript());
        this.validationEnabled = validationEnabled;
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpec instance) {
        this(instance, (Boolean)true);
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withScript(instance.getScript());
        this.validationEnabled = validationEnabled;
    }

    public BuildPostCommitSpec build() {
        BuildPostCommitSpec buildable = new BuildPostCommitSpec(this.fluent.getArgs(), this.fluent.getCommand(), this.fluent.getScript());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildPostCommitSpecBuilder that = (BuildPostCommitSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

