/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildRequestBuilder
extends BuildRequestFluentImpl<BuildRequestBuilder>
implements VisitableBuilder<BuildRequest, BuildRequestBuilder> {
    BuildRequestFluent<?> fluent;
    Boolean validationEnabled;

    public BuildRequestBuilder() {
        this(true);
    }

    public BuildRequestBuilder(Boolean validationEnabled) {
        this(new BuildRequest(), validationEnabled);
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildRequest(), validationEnabled);
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent, BuildRequest instance) {
        this(fluent, instance, true);
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent, BuildRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withBinary(instance.getBinary());
        fluent.withEnv(instance.getEnv());
        fluent.withFrom(instance.getFrom());
        fluent.withKind(instance.getKind());
        fluent.withLastVersion(instance.getLastVersion());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRevision(instance.getRevision());
        fluent.withTriggeredByImage(instance.getTriggeredByImage());
        this.validationEnabled = validationEnabled;
    }

    public BuildRequestBuilder(BuildRequest instance) {
        this(instance, (Boolean)true);
    }

    public BuildRequestBuilder(BuildRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withBinary(instance.getBinary());
        this.withEnv(instance.getEnv());
        this.withFrom(instance.getFrom());
        this.withKind(instance.getKind());
        this.withLastVersion(instance.getLastVersion());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withTriggeredByImage(instance.getTriggeredByImage());
        this.validationEnabled = validationEnabled;
    }

    public BuildRequest build() {
        BuildRequest buildable = new BuildRequest(this.fluent.getApiVersion(), this.fluent.getBinary(), this.fluent.getEnv(), this.fluent.getFrom(), this.fluent.getKind(), this.fluent.getLastVersion(), this.fluent.getMetadata(), this.fluent.getRevision(), this.fluent.getTriggeredByImage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildRequestBuilder that = (BuildRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

