/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DeploymentConfigListFluent;
import java.util.ArrayList;
import java.util.List;

public class DeploymentConfigListFluentImpl<A extends DeploymentConfigListFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends DeploymentConfig, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public DeploymentConfigListFluentImpl() {
    }

    public DeploymentConfigListFluentImpl(DeploymentConfigList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(DeploymentConfig ... items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(DeploymentConfig ... items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<DeploymentConfig> getItems() {
        return DeploymentConfigListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<DeploymentConfig> items) {
        this.items.clear();
        if (items != null) {
            for (DeploymentConfig item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(DeploymentConfig ... items) {
        this.items.clear();
        if (items != null) {
            for (DeploymentConfig item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> addNewItemLike(DeploymentConfig item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigListFluentImpl that = (DeploymentConfigListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<DeploymentConfigListFluent.MetadataNested<N>>
    implements DeploymentConfigListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends DeploymentConfigFluentImpl<DeploymentConfigListFluent.ItemsNested<N>>
    implements DeploymentConfigListFluent.ItemsNested<N>,
    Nested<N> {
        private final DeploymentConfigBuilder builder;

        ItemsNestedImpl() {
            this.builder = new DeploymentConfigBuilder(this);
        }

        ItemsNestedImpl(DeploymentConfig item) {
            this.builder = new DeploymentConfigBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

