package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link AzureDiskVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAzureDiskVolumeSourceAssert<S extends AbstractAzureDiskVolumeSourceAssert<S, A>, A extends AzureDiskVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAzureDiskVolumeSourceAssert}</code> to make assertions on actual AzureDiskVolumeSource.
   * @param actual the AzureDiskVolumeSource we want to make assertions on.
   */
  protected AbstractAzureDiskVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cachingMode so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert cachingMode()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCachingMode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cachingMode"));
  }


  /**
   * Navigates to the property diskName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert diskName()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDiskName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "diskName"));
  }


  /**
   * Navigates to the property diskURI so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert diskURI()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDiskURI()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "diskURI"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual AzureDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


}
