package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link AzureFileVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAzureFileVolumeSourceAssert<S extends AbstractAzureFileVolumeSourceAssert<S, A>, A extends AzureFileVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAzureFileVolumeSourceAssert}</code> to make assertions on actual AzureFileVolumeSource.
   * @param actual the AzureFileVolumeSource we want to make assertions on.
   */
  protected AbstractAzureFileVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert secretName()  {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSecretName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretName"));
  }


  /**
   * Navigates to the property shareName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert shareName()  {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getShareName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "shareName"));
  }


}
