package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerImage} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerImageAssert<S extends AbstractContainerImageAssert<S, A>, A extends ContainerImage> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerImageAssert}</code> to make assertions on actual ContainerImage.
   * @param actual the ContainerImage we want to make assertions on.
   */
  protected AbstractContainerImageAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property names so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> names()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "names"));
    return answer;
  }


  /**
   * Verifies that the actual ContainerImage's sizeBytes is equal to the given one.
   * @param sizeBytes the given sizeBytes to compare the actual ContainerImage's sizeBytes to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerImage's sizeBytes is not equal to the given one.
   */
  public S hasSizeBytes(Long sizeBytes) {
    // check that actual ContainerImage we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sizeBytes of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSizeBytes = actual.getSizeBytes();
    if (!Objects.areEqual(actualSizeBytes, sizeBytes)) {
      failWithMessage(assertjErrorMessage, actual, sizeBytes, actualSizeBytes);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
