package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Context} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContextAssert<S extends AbstractContextAssert<S, A>, A extends Context> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContextAssert}</code> to make assertions on actual Context.
   * @param actual the Context we want to make assertions on.
   */
  protected AbstractContextAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Context we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cluster so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert cluster()  {
    // check that actual Context we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCluster()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cluster"));
  }


  /**
   * Navigates to the property extensions so that assertions can be done on it
   */
  public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>() {
      public NamedExtensionAssert createAssert(NamedExtension t) {
        return (NamedExtensionAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(actual.getExtensions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"));
    return answer;
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual Context we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual Context we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
