package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link CronJobStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCronJobStatusAssert<S extends AbstractCronJobStatusAssert<S, A>, A extends CronJobStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCronJobStatusAssert}</code> to make assertions on actual CronJobStatus.
   * @param actual the CronJobStatus we want to make assertions on.
   */
  protected AbstractCronJobStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property active so that assertions can be done on it
   */
  public NavigationListAssert<ObjectReference, ObjectReferenceAssert> active()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ObjectReference, ObjectReferenceAssert> assertFactory = new AssertFactory<ObjectReference, ObjectReferenceAssert>() {
      public ObjectReferenceAssert createAssert(ObjectReference t) {
        return (ObjectReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<ObjectReference, ObjectReferenceAssert> answer = new NavigationListAssert<ObjectReference, ObjectReferenceAssert>(actual.getActive(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "active"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CronJobStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property lastScheduleTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastScheduleTime()  {
    // check that actual CronJobStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastScheduleTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastScheduleTime"));
  }


}
