package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeprecatedDownwardAPIVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeprecatedDownwardAPIVolumeSourceAssert<S extends AbstractDeprecatedDownwardAPIVolumeSourceAssert<S, A>, A extends DeprecatedDownwardAPIVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeprecatedDownwardAPIVolumeSourceAssert}</code> to make assertions on actual DeprecatedDownwardAPIVolumeSource.
   * @param actual the DeprecatedDownwardAPIVolumeSource we want to make assertions on.
   */
  protected AbstractDeprecatedDownwardAPIVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeprecatedDownwardAPIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DeprecatedDownwardAPIVolumeSource's defaultMode is equal to the given one.
   * @param defaultMode the given defaultMode to compare the actual DeprecatedDownwardAPIVolumeSource's defaultMode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeprecatedDownwardAPIVolumeSource's defaultMode is not equal to the given one.
   */
  public S hasDefaultMode(Integer defaultMode) {
    // check that actual DeprecatedDownwardAPIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting defaultMode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDefaultMode = actual.getDefaultMode();
    if (!Objects.areEqual(actualDefaultMode, defaultMode)) {
      failWithMessage(assertjErrorMessage, actual, defaultMode, actualDefaultMode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<DeprecatedDownwardAPIVolumeFile, DeprecatedDownwardAPIVolumeFileAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DeprecatedDownwardAPIVolumeFile, DeprecatedDownwardAPIVolumeFileAssert> assertFactory = new AssertFactory<DeprecatedDownwardAPIVolumeFile, DeprecatedDownwardAPIVolumeFileAssert>() {
      public DeprecatedDownwardAPIVolumeFileAssert createAssert(DeprecatedDownwardAPIVolumeFile t) {
        return (DeprecatedDownwardAPIVolumeFileAssert) assertThat(t);
      }
    };
    NavigationListAssert<DeprecatedDownwardAPIVolumeFile, DeprecatedDownwardAPIVolumeFileAssert> answer = new NavigationListAssert<DeprecatedDownwardAPIVolumeFile, DeprecatedDownwardAPIVolumeFileAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


}
