package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link EnvVarSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEnvVarSourceAssert<S extends AbstractEnvVarSourceAssert<S, A>, A extends EnvVarSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEnvVarSourceAssert}</code> to make assertions on actual EnvVarSource.
   * @param actual the EnvVarSource we want to make assertions on.
   */
  protected AbstractEnvVarSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configMapKeyRef so that assertions can be done on it
   */
  public ConfigMapKeySelectorAssert configMapKeyRef()  {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapKeySelectorAssert) assertThat(actual.getConfigMapKeyRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMapKeyRef"));
  }


  /**
   * Navigates to the property fieldRef so that assertions can be done on it
   */
  public ObjectFieldSelectorAssert fieldRef()  {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectFieldSelectorAssert) assertThat(actual.getFieldRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldRef"));
  }


  /**
   * Navigates to the property resourceFieldRef so that assertions can be done on it
   */
  public ResourceFieldSelectorAssert resourceFieldRef()  {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceFieldSelectorAssert) assertThat(actual.getResourceFieldRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceFieldRef"));
  }


  /**
   * Navigates to the property secretKeyRef so that assertions can be done on it
   */
  public SecretKeySelectorAssert secretKeyRef()  {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretKeySelectorAssert) assertThat(actual.getSecretKeyRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretKeyRef"));
  }


}
