package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link JobCondition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJobConditionAssert<S extends AbstractJobConditionAssert<S, A>, A extends JobCondition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobConditionAssert}</code> to make assertions on actual JobCondition.
   * @param actual the JobCondition we want to make assertions on.
   */
  protected AbstractJobConditionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property lastProbeTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastProbeTime()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastProbeTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastProbeTime"));
  }


  /**
   * Navigates to the property lastTransitionTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastTransitionTime()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastTransitionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTransitionTime"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert status()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual JobCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
